<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

require "conexion.php";

if ($connect->connect_error) {
    die("Connection failed: " . $connect->connect_error);
}
$profileData = array();
$productData = array();
$username = isset($_GET["username"]) ? $_GET["username"] : null;
$compan_code = isset($_GET["compan_code"]) ? $_GET["compan_code"] : null;

if ($username) {
    $profileData = array();
    $profileQuery = "SELECT 
        username,
        email,
        point
    FROM 
        users
    WHERE 
        username LIKE ?;";

    $stmt = $connect->prepare($profileQuery);
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $profileResult = $stmt->get_result();

    if ($profileResult) {
        if ($profileResult->num_rows == 1) {

            while ($row = $profileResult->fetch_assoc()) {
                $profileData[] = $row;
            }
        }
    } else {
        $profileData = [];
        echo json_encode(["error" => "Query error: " . $connect->error]);
        exit;
    }
}

$filter = '';
if ($compan_code) {
    if ($compan_code != 'all') $filter = "AND pd.compan_code = ?";

    $productQuery = "SELECT 
        pd.kode, 
        nama,
        image_url,
        SUM(pd.quantity) as quantity,
        price
    FROM 
        produk p 
		JOIN produkd pd ON p.kode = pd.kode 
		$filter GROUP by pd.kode ORDER BY price DESC";

    $stmt = $connect->prepare($productQuery);
    if ($compan_code != 'all')
        $stmt->bind_param("s", $compan_code);
    $stmt->execute();
    $productResult = $stmt->get_result();

    if ($productResult) {
        if ($productResult->num_rows > 0) {

            while ($row = $productResult->fetch_assoc()) {
                $productData[] = $row;
            }
        }
    } else {
        $productData = [];
        echo json_encode(["error" => "Query error: " . $connect->error]);
        exit;
    }
}

$initData = ['profileData' => $profileData, 'productData' => $productData];
$array = [
    'initData' => $initData,
];


echo json_encode($array);


// $insideReportData = [
//     "minQty" => $minQtyData,
//     "maxQty" => $maxQtyData,
//     "categoryFilter" => $compan_codeData,
//     "productName" => $productNameData
// ];