<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

include 'conexion.php';

$table = 'users';

// Get the JSON input
$getJson = file_get_contents('php://input');
$json = json_decode($getJson);

$username = $json->username;
$points = $json->points;

if (isset($username) && isset($points)) {
    // Menggunakan prepared statement untuk keamanan
    $updateQuery = "UPDATE $table SET point = point + ?, spin_chance = spin_chance - 1 WHERE username LIKE ?";
    $stmt = $connect->prepare($updateQuery);
    $stmt->bind_param("is", $points, $username);
    $updateSuccess = $stmt->execute();
    $stmt->close();

    if ($updateSuccess) {
        // Insert ke point_history
        $insertQuery = "INSERT INTO point_history (username, total_amount) VALUES (?, ?)";
        $stmt = $connect->prepare($insertQuery);
        $stmt->bind_param("si", $username, $points);
        $insertSuccess = $stmt->execute();
        $stmt->close();

        if ($insertSuccess) {
            $response = array(
                'error' => false,
                'message' => 'Points updated successfully'
            );
        } else {
            $response = array(
                'error' => true,
                'message' => 'Failed to insert into point history'
            );
        }
    } else {
        $response = array(
            'error' => true,
            'message' => 'Failed to update user points'
        );
    }
} else {
    $response = array(
        'error' => true,
        'message' => 'Invalid input data'
    );
}

echo json_encode($response);
?>
