<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
include 'conexion.php';

$data = array();

try {
    // Mengambil JSON input
    $getJson = file_get_contents('php://input');
    $json = json_decode($getJson);

    // Periksa apakah JSON valid dan memiliki username
    if (!$json || !isset($json->username)) {
        throw new Exception("Invalid JSON or missing 'username' field");
    }

    $user = $json->username;

    // Query untuk mengambil data
    $query = "SELECT * FROM requested_item WHERE USERNAME = ? ORDER BY REQUEST_ID DESC";
    $stmt = $connect->prepare($query);

    if (!$stmt) {
        throw new Exception("Failed to prepare statement: " . $connect->error);
    }

    $stmt->bind_param("s", $user);
    $stmt->execute();
    $result = $stmt->get_result();

    if (!$result) {
        throw new Exception("Query execution failed: " . $stmt->error);
    }

    // Memproses hasil query
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $data[] = $row;
        }
        echo json_encode(["data" => $data]);
    } else {
        throw new Exception("No data found");
    }
} catch (Exception $e) {
    // Menangani error dengan pesan yang jelas
    echo json_encode(["message" => $e->getMessage(), "error" => true]);
}
?>
