<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

require 'conexion.php';

// Set response sebagai JSON
header('Content-Type: application/json');

$data = array();

// Ambil username dari parameter GET
$username = isset($_GET['username']) ? $_GET['username'] : '';

if (!empty($username)) {
    // Gabungkan transaksi dari 'transactions' dan 'point_history'
    $query = "
    SELECT transaction_id, username, total_amount, transaction_date AS date, 'true' AS is_negative, status, is_delivery, 'Penukaran Point' AS keterangan
    FROM transactions 
    WHERE username = ? 
    UNION ALL 
    SELECT 0 AS transaction_id, username, total_amount, transaction_date AS date, 'false' AS is_negative, '3' AS status, 0 AS is_delivery, 'Lucky Spin' AS keterangan
    FROM point_history 
    WHERE username = ? 
    UNION ALL
    SELECT NO_BUKTI AS transaction_id, username,  POIN AS total_amount, TGL AS date, 'false' AS is_negative, '3' AS status, 0 AS is_delivery, 'Pembelanjaan' AS keterangan
    FROM users u JOIN jual j ON u.kodec = j.KODEC
    WHERE username = ?
    ORDER BY date DESC";

    $stmt = $connect->prepare($query);

    if ($stmt) {
        // Bind parameter dua kali karena digunakan dalam UNION
        $stmt->bind_param("sss", $username, $username, $username); 
        
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result && $result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $data[] = $row;
            }
            echo json_encode($data);
        } else {
            echo json_encode(array('message' => 'No data found'));
        }

        $stmt->close();
    } else {
        echo json_encode(array('error' => 'Query preparation failed'));
    }
} else {
    echo json_encode(array('error' => 'Username is required'));
}

$connect->close();
?>
