<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

require 'conexion.php';

// Set response sebagai JSON
header('Content-Type: application/json');

$data = array();

// Ambil transaction_id dari parameter GET
$transaction_id = isset($_GET['transaction_id']) ? $_GET['transaction_id'] : '';

if (!empty($transaction_id)) {
    
    $query = "
    SELECT ti.total_price, p.image_url, p.nama, ti.quantity
    FROM transaction_items ti JOIN produk p ON ti.kode = p.kode
    WHERE transaction_id = ? 
  ;";

    $stmt = $connect->prepare($query);

    if ($stmt) {
        // Bind parameter dua kali karena digunakan dalam UNION
        $stmt->bind_param("s", $transaction_id); 
        
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result && $result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $data[] = $row;
            }
            echo json_encode($data);
        } else {
            echo json_encode(array('message' => 'No data found'));
        }

        $stmt->close();
    } else {
        echo json_encode(array('error' => 'Query preparation failed'));
    }
} else {
    echo json_encode(array('error' => 'transaction_id is required'));
}

$connect->close();
?>
