<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

include 'conexion.php';

$getJson = file_get_contents('php://input');
$json = json_decode($getJson);

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username      = $json->username ?? null;
    $total_amount  = $json->total_amount ?? null;
    $is_delivery   = (isset($json->is_delivery) && $json->is_delivery) ? 1 : 0;
    $items         = $json->items ?? []; 

    // Validasi data
    if ($username && $total_amount !== null && is_array($items) && count($items) > 0) {
        $connect->begin_transaction();

        try {
            // Insert transaksi utama
            $stmt = $connect->prepare("INSERT INTO transactions (username, total_amount, is_delivery) VALUES (?, ?, ?)");
            $stmt->bind_param("sid", $username, $total_amount, $is_delivery);
            $stmt->execute();
            $transaction_id = $stmt->insert_id;
            $stmt->close();

            // Update point user
            $stmt = $connect->prepare("UPDATE users SET point = point - ? WHERE username = ?");
            $stmt->bind_param("is", $total_amount, $username);
            $stmt->execute();
            $stmt->close();

            // Proses setiap item
            $stmt_item = $connect->prepare("INSERT INTO transaction_items (transaction_id, kode, quantity, total_price) VALUES (?, ?, ?, ?)");
            $stmt_stock = $connect->prepare("UPDATE produkd SET quantity = quantity - ? WHERE kode = ? AND compan_code = ?");

            foreach ($items as $item) {
                $kode  = $item->kode;
                $quantity    = $item->quantity;
                $total_price = $item->total_price;
                $compan_code = $item->compan_code;

                // Insert item
                $stmt_item->bind_param("isid", $transaction_id, $kode, $quantity, $total_price);
                if (!$stmt_item->execute()) throw new Exception("Gagal insert item: " . $stmt_item->error);

                // Update stok
                $stmt_stock->bind_param("iss", $quantity, $kode, $compan_code);
                if (!$stmt_stock->execute()) throw new Exception("Gagal update stok: " . $stmt_stock->error);
            }

            $stmt_item->close();
            $stmt_stock->close();

            $connect->commit();
            echo json_encode(["message" => "Transaksi berhasil disimpan"]);
        } catch (Exception $e) {
            $connect->rollback();
            echo json_encode(["error" => "Terjadi kesalahan: " . $e->getMessage()]);
        }
    } else {
        echo json_encode(["error" => "Data input tidak valid"]);
    }
} else {
    echo json_encode(["error" => "Metode request tidak diizinkan"]);
}

$connect->close();
