<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
include 'conexion.php';

$getJson = file_get_contents('php://input');
$json = json_decode($getJson, true);

if (!$json) {
    echo json_encode([
        'error' => true,
        'message' => 'Invalid JSON format',
        'data' => null
    ]);
    exit;
}

// Ambil data dari JSON
$username = $json['username'];
$nik = $json['nik'];
$nama = $json['nama'];
$tempat_lahir = $json['tempat_lahir'];
$tanggal_lahir = $json['tanggal_lahir'];
$golongan_darah = $json['golongan_darah'];
$alamat = $json['alamat'];
$rt = $json['rt'];
$rw = $json['rw'];
$kelurahan = $json['kelurahan'];
$kecamatan = $json['kecamatan'];
$kota = $json['kota'];
$provinsi = $json['provinsi'];
$agama = $json['agama'];
$status_perkawinan = $json['status_perkawinan'];
$pekerjaan = $json['pekerjaan'];
$kewarganegaraan = $json['kewarganegaraan'];
$jenis_kelamin = $json['jenis_kelamin'];
$tanggal_lahir = date("Y-m-d", strtotime(str_replace("-", "/", $tanggal_lahir)));

// Pengecekan jika NIK sudah ada dengan username lain
try {
    $checkNikQuery = $connect->prepare("SELECT id, username FROM userd WHERE nik = ?");
    $checkNikQuery->bind_param("s", $nik);
    $checkNikQuery->execute();
    $result = $checkNikQuery->get_result();

    if ($result->num_rows > 0) {
        // NIK sudah ada, cek apakah username berbeda
        $existingUser = $result->fetch_assoc();
        if ($existingUser['username'] !== $username) {
            echo json_encode([
                'error' => true,
                'message' => 'NIK already exists with a different username',
                'data' => null
            ]);
            exit;
        }
    }
    $checkNikQuery->close();

    // Melakukan insert atau update jika NIK valid
    $sql = $connect->prepare("INSERT INTO userd (
        username, nik, nama, tempat_lahir, tanggal_lahir, jenis_kelamin, golongan_darah, alamat, rt, rw, kelurahan, kecamatan, kota, provinsi, agama, status_perkawinan, pekerjaan, kewarganegaraan
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ON DUPLICATE KEY UPDATE
        nik = VALUES(nik),
        nama = VALUES(nama),
        tempat_lahir = VALUES(tempat_lahir),
        tanggal_lahir = VALUES(tanggal_lahir),
        jenis_kelamin = VALUES(jenis_kelamin),
        golongan_darah = VALUES(golongan_darah),
        alamat = VALUES(alamat),
        rt = VALUES(rt),
        rw = VALUES(rw),
        kelurahan = VALUES(kelurahan),
        kecamatan = VALUES(kecamatan),
        kota = VALUES(kota),
        provinsi = VALUES(provinsi),
        agama = VALUES(agama),
        status_perkawinan = VALUES(status_perkawinan),
        pekerjaan = VALUES(pekerjaan),
        kewarganegaraan = VALUES(kewarganegaraan)");

    $sql->bind_param(
        "ssssssssssssssssss",
        $username,
        $nik,
        $nama,
        $tempat_lahir,
        $tanggal_lahir,
        $jenis_kelamin,
        $golongan_darah,
        $alamat,
        $rt,
        $rw,
        $kelurahan,
        $kecamatan,
        $kota,
        $provinsi,
        $agama,
        $status_perkawinan,
        $pekerjaan,
        $kewarganegaraan
    );

    if ($sql->execute()) {
        $affectedRows = $sql->affected_rows;

        // Cek apakah data baru dimasukkan atau diupdate
        if ($affectedRows > 0) {
            if ($affectedRows == 1 && $connect->insert_id != 0) {
                // Insert baru
                echo json_encode([
                    'error' => false,
                    'message' => 'User data inserted successfully',
                    'data' => [
                        'id' => $connect->insert_id,
                        'username' => $username,
                        'nik' => $nik
                    ]
                ]);
            } else {
                // Update data
                echo json_encode([
                    'error' => false,
                    'message' => 'User data updated successfully',
                    'data' => [
                        'id' => $connect->insert_id,
                        'username' => $username,
                        'nik' => $nik
                    ]
                ]);
            }
        } else {
            throw new Exception('No changes were made');
        }
    } else {
        throw new Exception('Failed to insert/update data');
    }

    $sql->close();
    $connect->close();
} catch (mysqli_sql_exception $e) {
    echo json_encode([
        'error' => true,
        'message' => 'Database error: ' . $e->getMessage(),
        'data' => null
    ]);
} catch (Exception $e) {
    echo json_encode([
        'error' => true,
        'message' => $e->getMessage(),
        'data' => null
    ]);
}
