<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

require 'conexion.php';

$table = 'notifications';
$result = false;

// Get the JSON payload
$getJson = file_get_contents('php://input');
$json = json_decode($getJson); // Decode the JSON

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Sanitize and extract data
    $id = $json->id;

    // Use a prepared statement to update the database
    $stmt = $connect->prepare("UPDATE " . $table . " SET isRead = true WHERE id = ?");
    $stmt->bind_param('i', $id); // 'i' means integer type for $id
    $stmt->execute();

    if ($stmt->affected_rows > 0) {
        $result = true;
    }
}

if ($result) {
    $response = array(
        'error' => false,
        'message' => 'Berhasil'
    );
} else {
    $response = array(
        'error' => true,
        'message' => 'Gagal'
    );
}

header('Content-Type: application/json');
echo json_encode($response);
