<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

require "conexion.php";

if ($connect->connect_error) {
    die("Connection failed: " . $connect->connect_error);
}

$categoryData = array();

// Query to fetch all categories
$categoryQuery = "SELECT 
    category_id,
    category_name
FROM 
    categories;";

$stmt = $connect->prepare($categoryQuery);
$stmt->execute();
$categoryResult = $stmt->get_result();

if ($categoryResult) {
    if ($categoryResult->num_rows > 0) {
        while ($row = $categoryResult->fetch_assoc()) {
            $categoryData[] = $row;
        }
    }
} else {
    $categoryData = [];
    echo json_encode(["error" => "Query error: " . $connect->error]);
    exit;
}

// Return the categories as JSON response
echo json_encode($categoryData);
